# Quote parameters to tr to prevent glob expansion.

### Problematic code:

```sh
tr -cd [:digit:]
```

### Correct code:

```sh
tr -cd '[:digit:]'
```

### Rationale:

`[:digit:]` is a shell glob that matches any single character file named e.g. `g` or `t` in the current directory. Quoting it prevents the script from breaking in directories with files like this.

### Exceptions

None

[Source](https://github.com/koalaman/shellcheck/wiki/SC2060)

