## Assigning an array to a string! Assign as array, or use * instead of @ to concatenate.

### Problematic code:

```sh
var=$@
for i in $var; do ..; done
```

or

```sh
set -- Hello World
msg=$@
echo "You said $msg"
```

### Correct code:

```sh
var=( "$@" )
for i in "${var[@]}"; do ..; done
```

or

```sh
set -- Hello World
msg=$*
echo "You said $msg"
```

### Rationale:

Arrays and `$@` can contain multiple elements. Simple variables contain only one. When assigning multiple elements to one element, the default behavior depends on the shell (bash concatenates with spaces, zsh concatenates with first char of `IFS`).

Since doing this usually indicates a bug, ShellCheck warns and asks you to be explicit about what you want.

If you want to assign N elements as N elements, use an array, e.g. `myArray=( "$@" )`.

If you want to assign N elements as 1 element by concatenating them, use `*` instead of `@`, e.g. `myVar=${myArray[*]}` (this separates elements with the first character of `IFS`, usually space).

The same is true for `${@: -1}`, which results in 0 or 1 elements: `var=${*: -1}` assigns the last element or an empty string.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2124)

