## Can only return 0-255. Other data should be written to stdout.

### Problematic code:

```sh
myfunc() {
  return "Hello $USER"
}
```

### Correct code:

```sh
myfunc() {
  echo "Hello $USER"
  return 0
}
```

### Rationale:

In many languages, `return` is used to return from the function with a final result.

In bash, `return` can only be used to signal success or failure (0 = success, 1-255 = failure), more akin to `throw/raise` in other languages.

Results should instead be written to stdout and captured:

```sh
message=$(myfunc)
echo "The function wrote: $message"
```

In functions that return small integers, such as getting the cpu temperature, the value should still be written to stdout. `return` should be reserved for error conditions, such as "can't determine CPU temperature".

### Exceptions:

None

### Related resources:

* [BashFaq: How do I return a string (or large number, or negative number) from a function?](https://mywiki.wooledge.org/BashFAQ/084) "return" only lets me give a number from 0 to 255.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2152)

