## [ false ] is true. Remove the brackets

### Problematic code:

```sh
if [ false ]
then
  echo "triggers anyways"
fi
```

### Correct code:

```sh
if false
then
  echo "never triggers"
fi
```

### Rationale:

`[ str ]` checks whether `str` is non-empty. It doesn't matter if `str` is `false`, it will still be evaluated for non-emptyness.

Instead, use the command `false` which -- as the manual puts it -- does nothing, unsuccessfully.

### Exceptions:

None

[Source](https://github.com/koalaman/shellcheck/wiki/SC2158)

