## Use var=$(command) to assign output (or quote to assign string).

### Problematic code:

```sh
user=whoami         # Want to run whoami and assign output

PAGER=cat git log   # Want to assign the string "cat"
```

### Correct code:

```sh
user=$(whoami)

PAGER="cat" git log
```

### Rationale:

Putting `var=` in front of a command will not assign its output. Use `var=$(my command here)` to execute the command and capture its output.

If you do want to assign a literal string, use quotes to make this clear to shellcheck and humans alike. 

### Exceptions:

None. 

Quoting a single command (as in `PAGER="cat"` above) doesn't change how the script works. It's purely to show shellcheck (and humans) that a literal assignment of a command name is intentional. 

This warning triggers generally when a variable is assigned an unquoted command name (from a list of hard coded names). See related warning [[SC2037]] which detects the same kind of error through the patterns `var=value -flag` and `var=value *glob*`.

### Related resources:

* [BashFaq: How can I store the return value and/or output of a command in a variable?](https://mywiki.wooledge.org/BashFAQ/002)
* [StackOverflow: How to set a variable to the output from a command in Bash](https://stackoverflow.com/questions/4651437/how-to-set-a-variable-to-the-output-from-a-command-in-bash)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2209)

