Shared naming conventions allow teams to collaborate efficiently. This rule checks whether or not method and property names are camel cased. To
reduce noise, two consecutive upper case characters are allowed unless they form the whole name. So, `MyXMethod` is compliant, but
`XM` on its own is not.

## Noncompliant Code Example

<pre>
public int doSomething(){...}
</pre>

## Compliant Solution

<pre>
public int DoSomething(){...}
</pre>

## Exceptions

The rule ignores members in types that are marked with `ComImportAttribute` or `InterfaceTypeAttribute`. `extern`
methods are also excluded from the check. Furthermore, when `'_'` character is found in a name, the camel casing is not enforced.

<pre>
void My_method(){...} // valid
void My_method_(){...} // invalid, leading and trailing underscores are reported
</pre>