Shadowing fields with a local variable is a bad practice that reduces code readability: it makes it confusing to know whether the field or the
variable is being used.

## Noncompliant Code Example

<pre>
class Foo
{
  public int myField;

  public void DoSomething()
  {
    int myField = 0;  // Noncompliant
    ...
  }
}
</pre>

## See

*   [CERT, DCL51-J.](https://www.securecoding.cert.org/confluence/x/2ADEAw) - Do not shadow or obscure identifiers in subscopes