Unused parameters are misleading. Whatever the values passed to such parameters, the behavior will be the same.

## Noncompliant Code Example

<pre>
void DoSomething(int a, int b) // "b" is unused
{
  Compute(a);
}

void DoSomething2(int a) // value of "a" is unused
{
  a = 10;
  Compute(a);
}
</pre>

## Compliant Solution

<pre>
void DoSomething(int a)
{
  Compute(a);
}

void DoSomething2()
{
  var a = 10;
  Compute(a);
}
</pre>

## Exceptions

`virtual`, `override` methods and interface implementations are ignored. 

<pre>
override void DoSomething(int a, int b) // no issue reported on b
{
  Compute(a);
}
</pre>

Furthermore, the `this` parameter of extension methods is also ignored.

<pre>
public static class Extensions
{
  public static void MyHelper(this HtmlHelper helper) //no issue reported here
  {
    // no use of helper here
  }
}
</pre>

Methods that have attributes defined on them are ignored.

<pre>
public class MyDto
{
  public string Name { get; set; }

  [OnDeserialized]
  private void OnDeserialized(StreamingContext context)
  {
    // ...
  }
}
</pre>

Empty or unsupported methods are ignored.

<pre>
public void DoSomething()
{}

public void Call()
{
  throw new NotImplementedException();
}
</pre>

And obviously no issue is raised on the `static void Main(string[] args)` method

## See

*   MISRA C++:2008, 0-1-11 - There shall be no unused parameters (named or unnamed) in nonvirtual functions.
*   MISRA C:2012, 2.7 - There should be no unused parameters in functions
*   [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never
      executed
*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect