There are several reasons for a method not to have a method body:

*   It is an unintentional omission, and should be fixed.
*   It is not yet, or never will be, supported. In this case a `NotSupportedException` should be thrown.
*   The method is an intentionally-blank override. In this case a nested comment should explain the reason for the blank override.

## Noncompliant Code Example

<pre>
public override void DoSomething()
{
}

public override void DoSomethingElse()
{
}
</pre>

## Compliant Solution

<pre>
public override void DoSomething()
{
  // Do nothing because of X and Y.
}

public override void DoSomethingElse()
{
  throw new NotSupportedException();
}
</pre>

## Exceptions

The following methods are ignored:

*   empty `virtual` methods,
*   empty methods that override an `abstract` method,
*   empty overrides in test assemblies.