There is a contract between `Equals(object)` and `GetHashCode()`: If two objects are equal according to the
`Equals(object)` method, then calling `GetHashCode()` on each of them must yield the same result. If this is not the case, many
collections won't handle class instances correctly.

In order to comply with the contract, `Equals(object)` and `GetHashCode()` should be either both inherited, or both
overridden.

## Noncompliant Code Example

<pre>
class MyClass {    // Noncompliant - should also override "hashCode()"

  @Override
  public boolean equals(Object obj) {
    /* ... */
  }

}
</pre>

## Compliant Solution

<pre>
class MyClass {    // Compliant

  @Override
  public boolean equals(Object obj) {
    /* ... */
  }

  @Override
  public int hashCode() {
    /* ... */
  }

}
</pre>

## See

*   [MITRE, CWE-581](http://cwe.mitre.org/data/definitions/581.html) - Object Model Violation: Just One of Equals and Hashcode Defined

*   [CERT, MET09-J.](https://www.securecoding.cert.org/confluence/x/EYYbAQ) - Classes that define an equals() method must also define a
      hashCode() method