Floating point math is imprecise because of the challenges of storing such values in a binary representation. Even worse, floating point math is
not associative; push a `float` or a `double` through a series of simple mathematical operations and the answer will be
different based on the order of those operation because of the rounding that takes place at each step.

Even simple floating point assignments are not simple:

<pre>
float f = 0.100000001f; // 0.1
double d = 0.10000000000000001; // 0.1
</pre>

(Results will vary based on compiler and compiler settings)

Therefore, the use of the equality (`==`) and inequality (`!=`) operators on `float` or `double` values
is almost always an error.

This rule checks for the use of direct and indirect equality/inequailty tests on floats and doubles.

## Noncompliant Code Example

<pre>
float myNumber = 3.146f;
if ( myNumber == 3.146f ) //Noncompliant. Because of floating point imprecision, this will be false
{
  // ...
}

if (myNumber &lt;= 3.146f &amp;&amp; mNumber &gt;= 3.146f) // Noncompliant indirect equality test
{
  // ...
}

if (myNumber &lt; 4 || myNumber &gt; 4) // Noncompliant indirect inequality test
{
  // ...
}
</pre>

## See

*   MISRA C:2004, 13.3 - Floating-point expressions shall not be tested for equality or inequality.
*   MISRA C++:2008, 6-2-2 - Floating-point expressions shall not be directly or indirectly tested for equality or inequality