Hardcoding an IP address into source code is a bad idea for several reasons:

*   a recompile is required if the address changes
*   it forces the same address to be used in every environment (dev, sys, qa, prod)
*   it places the responsibility of setting the value to use in production on the shoulders of the developer
*   it allows attackers to decompile the code and thereby discover a potentially sensitive address

## Noncompliant Code Example

<pre>
var ip = "127.0.0.1";
var address = IPAddress.Parse(ip);
</pre>

## Compliant Solution

<pre>
var ip = ConfigurationManager.AppSettings["myapplication.ip"];
var address = IPAddress.Parse(ip);
</pre>

## Exceptions

Although "::" is a valid IPv6 address, the rule doesn't report on it. 

## See

*   [CERT, MSC03-J.](https://www.securecoding.cert.org/confluence/x/qQCHAQ) - Never hard code sensitive information