If a local variable is declared but not used, it is dead code and should be removed. Doing so will improve maintainability because developers will
not wonder what the variable is used for.

## Noncompliant Code Example

<pre>
public int NumberOfMinutes(int hours)
{
  int seconds = 0;   // seconds is never used
  return hours * 60;
}
</pre>

## Compliant Solution

<pre>
public int NumberOfMinutes(int hours)
{
  return hours * 60;
}
</pre>

## Exceptions

Unused locally created resources in a `using` statement are not reported.

<pre>
using(var t = new TestTimer()) // t never used, but compliant.
{
  //...
}
</pre>