Declaring multiple variable on one line is difficult to read.

## Noncompliant Code Example

<pre>
class MyClass
{
  private int a, b; // Noncompliant

  public void Method()
  {
    int c, d; // Noncompliant
  }
}
</pre>

## Compliant Solution

<pre>
class MyClass
{
  private int a;
  private int b;

  public void Method()
  {
    int c;
    int d;
  }
}
</pre>

## See

*   MISRA C++:2008, 8-0-1 - An init-declarator-list or a member-declarator-list shall consist of a single init-declarator or member-declarator
      respectively
*   [CERT, DCL52-J.](https://www.securecoding.cert.org/confluence/x/7wHEAw) - Do not declare more than one variable per declaration

*   [CERT, DCL04-C.](https://www.securecoding.cert.org/confluence/x/VgU) - Do not declare more than one variable per declaration
*   [CERT, DCL04-CPP.](https://www.securecoding.cert.org/confluence/x/fAAhAQ) - Do not declare more than one variable per declaration