When either the equality operator in a null test or the logical operator that follows it is reversed, the code has the appearance of safely
null-testing the object before dereferencing it. Unfortunately the effect is just the opposite - the object is null-tested and then dereferenced
_only_ if it is null, leading to a guaranteed null pointer dereference.

## Noncompliant Code Example

<pre>
if (str == null &amp;&amp; str.length() == 0) {
  System.out.println("String is empty");
}

if (str != null || str.length() &gt; 0) {
  System.out.println("String is not empty");
}
</pre>

## Compliant Solution

<pre>
if (str == null || str.Length == 0)
{
  Console.WriteLine("String is empty");
}

if (str != null &amp;&amp; str.Length &gt; 0)
{
  Console.WriteLine("String is not empty");
}
</pre>

## Deprecated

This rule is deprecated; use {rule:csharpsquid:S2259} instead.