When division is performed on `int`s, the result will always be an `int`. You can assign that result to a
`double`, `float` or `decimal` with automatic type conversion, but having started as an `int`, the result
will likely not be what you expect. If the result of `int` division is assigned to a floating-point variable, precision will have been lost
before the assignment. Instead, at least one operand should be cast or promoted to the final type before the operation takes place.

## Noncompliant Code Example

<pre>
static void Main()
{
  decimal dec = 3/2; // Noncompliant
  Method(3/2); // Noncompliant
}

static void Method(float f) { }
</pre>

## Compliant Solution

<pre>
static void Main()
{
  decimal dec = (decimal)3/2;
  Method(3.0F/2);
}

static void Method(float f) { }
</pre>

## See

*   MISRA C++:2008, 5-0-8 - An explicit integral or floating-point conversion shall not increase the size of the underlying type of a cvalue
      expression.
*   [MITRE, CWE-190](http://cwe.mitre.org/data/definitions/190) - Integer Overflow or Wraparound
*   [CERT, NUM50-J.](https://www.securecoding.cert.org/confluence/x/woIyAQ) - Convert integers to floating point for floating-point
      operations
*   [CERT, INT18-C.](https://www.securecoding.cert.org/confluence/x/AxE) - Evaluate integer expressions in a larger size before
      comparing or assigning to that size
*   [CERT, INT18-CPP.](https://www.securecoding.cert.org/confluence/x/1IAyAQ) - Evaluate integer expressions in a larger size before
      comparing or assigning to that size
*   [SANS Top 25](http://www.sans.org/top25-software-errors/) - Risky Resource Management