When the call to a function doesn't have any side effects, what is the point of making the call if the results are ignored? In such case, either
the function call is useless and should be dropped or the source code doesn't behave as expected.

This rule raises an issue when the results of the following methods are ignored:

*   LINQ method,
*   `[Pure]` method,
*   any method on `string`, `int`, ..., `System.Collections.Immutable.ImmutableArray<T>`,
      `ImmutableHashSet<T>`, ...

## Noncompliant Code Example

<pre>
coll.Where(i =&gt; i &gt; 5).Select(i =&gt; i*i); // Noncompliant
"this string".Equals("other string"); // Noncompliant
</pre>

## Compliant Solution

<pre>
var res = coll.Where(i =&gt; i &gt; 5).Select(i =&gt; i*i);
var isEqual = "this string".Equals("other string");
</pre>

## Exceptions

This rule doesn't report issues on method calls with `out` or `ref` arguments.

## See

*   MISRA C:2012, 17.7 - The value returned by a function having non-void return type shall be used
*   [CERT, EXP12-C.](https://www.securecoding.cert.org/confluence/x/9YIRAQ) - Do not ignore values returned by functions
*   [CERT, EXP12-CPP.](https://www.securecoding.cert.org/confluence/x/eoAyAQ) - Do not ignore values returned by functions or methods

*   [CERT, EXP00-J.](https://www.securecoding.cert.org/confluence/x/9gEqAQ) - Do not ignore values returned by methods