Calling `ToString()` on an object should always return a string. Returning `null` instead contravenes the method's implicit
contract.

## Noncompliant Code Example

<pre>
public override string ToString ()
{
  if (this.collection.Count == 0)
  {
    return null; // Noncompliant
  }
  else
  {
    // ...
  }
}
</pre>

## Compliant Solution

<pre>
public override string ToString ()
{
  if (this.collection.Count == 0)
  {
    return string.Empty;
  }
  else
  {
    // ...
  }
}
</pre>

## See

*   [MITRE CWE-476](http://cwe.mitre.org/data/definitions/476.html) - NULL Pointer Dereference