According to the US National Institute of Standards and Technology (NIST), the Data Encryption Standard (DES) is no longer considered secure:

> Adopted in 1977 for federal agencies to use in protecting sensitive, unclassified information, the DES is being withdrawn because it no longer
>   provides the security that is needed to protect federal government information.
> 
> Federal agencies are encouraged to use the Advanced Encryption Standard, a faster and stronger algorithm approved as FIPS 197 in 2001.

For similar reasons, RC2 should also be avoided.

## Noncompliant Code Example

<pre>
using (var tripleDES = new TripleDESCryptoServiceProvider()) //Noncompliant
{
  //...
}
</pre>

## Compliant Solution

<pre>
using (var aes = new AesCryptoServiceProvider())
{
  //...
}
</pre>

## See

*   [MITRE CWE-326](http://cwe.mitre.org/data/definitions/326.html) - Inadequate Encryption Strength
*   [MITRE CWE-327](http://cwe.mitre.org/data/definitions/327.html) - Use of a Broken or Risky Cryptographic Algorithm
*   [OWASP Top Ten 2013 Category A6](https://www.owasp.org/index.php/Top_10_2013-A6-Sensitive_Data_Exposure) - Sensitive Data Exposure

*   [CERT, MSC61-J.](https://www.securecoding.cert.org/confluence/x/VwAZAg) - Do not use insecure or weak cryptographic algorithms
*   Derived from FindSecBugs rule [DES / DESede Unsafe](http://h3xstream.github.io/find-sec-bugs/bugs.htm#DES_USAGE)