Type parameters that aren't used are dead code, which can only distract and possibly confuse developers during maintenance. Therefore, unused type
parameters should be removed.

## Noncompliant Code Example

<pre>
public class MoreMath
 <t>
     // Noncompliant; 
  <t>
    is ignored { public int Add
   <t>
    (int a, int b) // Noncompliant; 
    <t>
      is ignored { return a + b; } } 
    </t>
   </t>
  </t>
 </t></pre>

## Compliant Solution

<pre>
public class MoreMath
{
  public int Add (int a, int b)
  {
    return a + b;
  }
}
</pre>

## See

*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect