The overloading mechanism should be used in place of optional parameters for several reasons:

*   Optional parameter values are baked into the method call site code, thus, if a default value has been changed, all referencing assemblies need
      to be rebuilt, otherwise the original values will be used.
*   The Common Language Specification (CLS) allows compilers to ignore default parameter values, and thus require the caller to explicitly specify
      the values.
*   The concept of optional argument exists only in VB.Net and C#. In all other languages like C++ or Java, the overloading mechanism is the only
      way to get the same behavior.
*   Optional parameters prevent muddying the definition of the function contract. Here is a simple example: if there are two optional parameters,
      when one is defined, is the second one still optional or mandatory?

## Noncompliant Code Example

<pre>
void Notify(string company, string office = "QJZ") // Noncompliant
{
}
</pre>

## Compliant Solution

<pre>
void Notify(string company)
{
  Notify(company, "QJZ");
}
void Notify(string company, string office)
{
}
</pre>

## Exceptions

The rule ignores non externally visible methods.