Most developers expect property access to be as efficient as field access. However, if a property returns a copy of an array or collection, it will
be much slower than a simple field access, contrary to the caller's likely expectations. Therefore, such properties should be refactored into methods
so that callers are not surprised by unexpectedly poor performance.

## Noncompliant Code Example

<pre>
private List
 <string>
   _foo = new List
  <string>
    { "a", "b", "c" }; public IEnumerable
   <string>
     Foo // Noncompliant { get { return _foo.ToList(); } } private string[] _bar = new string[] { "a", "b", "c" }; public IEnumerable
    <string>
      Bar // Noncompliant { get { return (string[])_bar.Clone(); } } 
    </string>
   </string>
  </string>
 </string></pre>

## Compliant Solution

<pre>
private List
 <string>
   _foo = new List
  <string>
    { "a", "b", "c" }; private string[] _bar = new string[] { "a", "b", "c" }; public IEnumerable
   <string>
     GetFoo() { return _foo.ToList(); } public IEnumerable
    <string>
      GetBar() { return (string[])_bar.Clone(); } 
    </string>
   </string>
  </string>
 </string></pre>