Exposing methods with multidimensional array parameters requires developers to have advanced knowledge about the language in order to be able to
use them. Moreover, what exactly to pass to such parameters is not intuitive. Therefore, such methods should not be exposed, but can be used
internally.

## Noncompliant Code Example

<pre>
public class Program
{
    public void WriteMatrix(int[][] matrix) // Non-Compliant
    {
    }
}
</pre>

## Compliant Solution

<pre>
public class Matrix
{
    // ...
}

public class Program
{
    public void WriteMatrix(Matrix matrix) // Compliant
    {
    }
}
</pre>