Conditional expressions which are always `true` or `false` can lead to dead code. Such code is always buggy and should never
be used in production.

## Noncompliant Code Example

<pre>
a = false;
if (a) // Noncompliant
{
  DoSomething(); // never executed
}

if (!a || b) // Noncompliant; "!a" is always "true", "b" is never evaluated
{
  DoSomething();
}
else
{
  DoSomethingElse(); // never executed
}
</pre>

## See

*   MISRA C:2004, 13.7 - Boolean operations whose results are invariant shall not be permitted.
*   MISRA C:2012, 14.3 - Controlling expressions shall not be invariant
*   [MITRE, CWE-570](http://cwe.mitre.org/data/definitions/570.html) - Expression is Always False
*   [MITRE, CWE-571](http://cwe.mitre.org/data/definitions/571) - Expression is Always True
*   [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never
      executed
*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect