Most checks against an `IndexOf` value compare it with -1 because 0 is a valid index. Any checks which look for values
`>0` ignore the first element, which is likely a bug. If the intent is merely to check inclusion of a value in a `string`,
`List`, or an array, consider using the `Contains` method instead.

This rule raises an issue when an `IndexOf` value retrieved from a `string`, `List`, or array is tested against
`>0`.

## Noncompliant Code Example

<pre>
string color = "blue";
string name = "ishmael";

List
 <string>
   strings = new List
  <string>
   (); strings.Add(color); strings.Add(name); string[] stringArray = strings.ToArray(); if (strings.IndexOf(color) &gt; 0) // Noncompliant { // ... } if (name.IndexOf("ish") &gt; 0) // Noncompliant { // ... } if (name.IndexOf("ae") &gt; 0) // Noncompliant { // ... } if (Array.IndexOf(stringArray, color) &gt; 0) // Noncompliant { // ... } 
  </string>
 </string></pre>

## Compliant Solution

<pre>
string color = "blue";
string name = "ishmael";

List
 <string>
   strings = new List
  <string>
    (); strings.Add(color); strings.Add(name); string[] stringArray = strings.ToArray(); if (strings.IndexOf(color) &gt; -1) { // ... } if (name.IndexOf("ish") &gt;= 0) { // ... } if (name.Contains("ae")) { // ... } if (Array.IndexOf(stringArray, color) &gt;= 0) { // ... } 
  </string>
 </string></pre>