Classes with `IDisposable` members are responsible for cleaning up those members by calling their `Dispose` methods. The best
practice here is for the owning class to itself implement `IDisposable` and call its members' `Dispose` methods from its own
`Dispose` method.

## Noncompliant Code Example

<pre>
public class ResourceHolder   // Noncompliant; doesn't implement IDisposable
{
  private FileStream fs;  // This member is never Dispose'd
  public void OpenResource(string path)
  {
    this.fs = new FileStream(path, FileMode.Open);
  }
  public void CloseResource()
  {
    this.fs.Close();
  }
}
</pre>

## Compliant Solution

<pre>
public class ResourceHolder : IDisposable
{
&nbsp;&nbsp;private FileStream fs;
&nbsp;&nbsp;public void OpenResource(string path)
&nbsp;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;this.fs = new FileStream(path, FileMode.Open);
&nbsp;&nbsp;}
&nbsp;&nbsp;public void CloseResource()
&nbsp;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;this.fs.Close();
&nbsp;&nbsp;}

&nbsp;&nbsp;public void Dispose()
&nbsp;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;this.fs.Dispose();
&nbsp;&nbsp;}
}
</pre>

## See

*   [MITRE, CWE-459](http://cwe.mitre.org/data/definitions/459.html) - Incomplete Cleanup