`readonly` fields can only be assigned in a class constructor. If a class has a field that's not marked `readonly` but is
only set in the constructor, it could cause confusion about the field's intended use. To avoid confusion, such fields should be marked
`readonly` to make their intended use explicit, and to prevent future maintainers from inadvertently changing their use.

## Noncompliant Code Example

<pre>
class Person
{
  int _birthYear;  // Noncompliant
  Person(int birthYear)
  {
    _birthYear = birthYear;
  }
}
</pre>

## Compliant Solution

<pre>
class Person
{
  readonly int _birthYear;
  Person(int birthYear)
  {
    _birthYear = birthYear;
  }
}
</pre>

## Exceptions

Fields with attributes are ignored.