In the interests of readability, code that can be simplified should be simplified. To that end, there are several ways `IEnumerable
LINQ`s can be simplified

*   Use `OfType` instead of using `Select` with `as` to type cast elements and then null-checking in a query
      expression to choose elements based on type.
*   Use `OfType` instead of using `Where` and the `is` operator, followed by a cast in a `Select`
*   Use an expression in `Any` instead of `Where(element => [expression]).Any()`.
*   Use `Count` instead of `Count()` when it's available.
*   Don't call `ToArray()` or `ToList()` in the middle of a query chain.

## Noncompliant Code Example

<pre>
seq1.Select(element =&gt; element as T).Any(element =&gt; element != null);  // Noncompliant; use OfType
seq2.Select(element =&gt; element as T).Any(element =&gt; element != null &amp;&amp; CheckCondition(element));  // Noncompliant; use OfType
seq3.Where(element =&gt; element is T).Select(element =&gt; element as T); // Noncompliant; use OfType
seq4.Where(element =&gt; element is T).Select(element =&gt; (T)element); // Noncompliant; use OfType
seq5.Where(element =&gt; [expression]).Any();  // Noncompliant; use Any([expression])

var num = seq6.Count(); // Noncompliant
var arr = seq.ToList().ToArray(); //Noncompliant
var count = seq.ToList().Count(x=&gt;[condition]); //Noncompliant
</pre>

## Compliant Solution

<pre>
seq1.OfType
 <t>
  ().Any();
seq2.OfType
  <t>
   ().Any(element =&gt; CheckCondition(element)); seq3.OfType
   <t>
    (); seq4.OfType
    <t>
     (); seq5.Any(element =&gt; [expression]) var num = seq6.Count; var arr = seq.ToArray(); var count = seq.Count(x=&gt;[condition]); 
    </t>
   </t>
  </t>
 </t></pre>