`GC.SuppressFinalize` asks the Common Language Runtime not to call the finalizer of an object. This is useful when implementing the
dispose pattern where object finalization is already handled in `IDisposable.Dispose`. However, it has no effect if there is no finalizer
defined in the object's type, so using it in such cases is just confusing.

This rule raises an issue when `GC.SuppressFinalize` is called for objects of `sealed` types without a finalizer.

## Noncompliant Code Example

<pre>
sealed class MyClass
{
  public void Method()
  {
    ...
    GC.SuppressFinalize(this); //Noncompliant
  }
}
</pre>

## Compliant Solution

<pre>
sealed class MyClass
{
  public void Method()
  {
    ...
  }
}
</pre>