In property and indexer `set` methods, and in event `add` and `remove` methods, the implicit `value`
parameter holds the value the accessor was called with. Not using the `value` means that the accessor ignores the caller's intent which
could cause unexpected results at runtime.

## Noncompliant Code Example

<pre>
private int count;
public int Count
{
  get { return count; }
  set { count = 42; } // Noncompliant
}
</pre>

## Compliant Solution

<pre>
private int count;
public int Count
{
  get { return count; }
  set { count = value; }
}
</pre>

or

<pre>
public int Count
{
  get { return count; }
  set { throw new InvalidOperationException(); }
}
</pre>