Using `string.Equals` to determine if a string is empty is significantly slower than using `string.IsNullOrEmpty()` or
checking for `string.Length == 0`. `string.IsNullOrEmpty()` is both clear and concise, and therefore preferred to laborious,
error-prone, manual null- and emptiness-checking.

## Noncompliant Code Example

<pre>
"".Equals(name); // Noncompliant
!name.Equals(""); // Noncompliant
name.Equals(string.Empty); // Noncompliant
</pre>

## Compliant Solution

<pre>
name != null &amp;&amp; name.Length &gt; 0 // Compliant but more error prone
!string.IsNullOrEmpty(name)
string.IsNullOrEmpty(name)
</pre>