Overriding methods automatically inherit the `params` behavior. To ease readability, this modifier should be explicitly used in the
overriding method as well.

## Noncompliant Code Example

<pre>
class Base
{
  public virtual void Method(params int[] numbers)
  {
    ...
  }
}
class Derived : Base
{
  public override void Method(int[] numbers) // Noncompliant, the params is missing.
  {
    ...
  }
}
</pre>

## Compliant Solution

<pre>
class Base
{
  public virtual void Method(params int[] numbers)
  {
    ...
  }
}
class Derived : Base
{
  public override void Method(params int[] numbers)
  {
    ...
  }
}
</pre>