Adherence to the standard naming conventions makes your code not only more readable, but more usable. For instance, `class FirstAttribute :
Attribute` can be used simply with `First`, but you must use the full name for `class AttributeOne : Attribute`.

This rule raises an issue when classes extending `Attribute`, `EventArgs`, or `Exception`, do not end with their
parent class names.

## Noncompliant Code Example

<pre>
class AttributeOne : Attribute  // Noncompliant
{
}
</pre>

## Compliant Solution

<pre>
class FirstAttribute : Attribute
{
}
</pre>

## Exceptions

If a class' direct base class doesn't follow the convention, then no issue is reported on the class itself, regardless of whether or not it
conforms to the convention.

<pre>
class Timeout : Exception // Noncompliant
{
}
class ExtendedTimeout : Timeout // Ignored; doesn't conform to convention, but the direct base doesn't conform either
{
}
</pre>