The rules for method resolution are complex and perhaps not properly understood by all coders. Having overloads with optional parameter values
makes the matter even harder to understand. 

This rule raises an issue when an overload with default parameter values is hidden by one without the optional parameters. 

## Noncompliant Code Example

<pre>
public class MyClass
{
  void Print(string[] messages) {...}
  void Print(string[] messages, string delimiter = "\n") {...} // Noncompliant; default parameter value is hidden by overload
}

// ...
MyClass myClass = new MyClass();

myClass.Print(new string[3] {"yes", "no", "maybe"});  // which version of Print will be called?
</pre>