When rethrowing an exception, you should do it by simply calling `throw;` and not `throw exc;`, because the stack trace is
reset with the second syntax, making debugging a lot harder.

## Noncompliant Code Example

<pre>
try
{}
catch(ExceptionType1 exc)
{
  Console.WriteLine(exc);
  throw exc; // Noncompliant; stacktrace is reset
}
catch (ExceptionType2 exc)
{
  throw new Exception("My custom message", exc);  // Compliant; stack trace preserved
}
</pre>

## Compliant Solution

<pre>
try
{}
catch(ExceptionType1 exc)
{
  Console.WriteLine(exc);
  throw;
}
catch (ExceptionType2 exc)
{
  throw new Exception("My custom message", exc);
}
</pre>