A class with only `private` constructors can't be instantiated, thus, it seems to be pointless code.

## Noncompliant Code Example

<pre>
public class MyClass // Noncompliant
{
  private MyClass() { ... }
}
</pre>

## Compliant Solution

<pre>
public class MyClass
{
  public MyClass() { ... }
}
</pre>

## Exceptions

Classes that themselves access their private constructors (singletons or smart enums) are ignored. Classes with only `static` members
are also ignored because they are covered by Rule S1118.