Adding `params` to a method override has no effect. The compiler accepts it, but the callers won't be able to benefit from the added
modifier.

## Noncompliant Code Example

<pre>
class Base
{
  public virtual void Method(int[] numbers)
  {
    ...
  }
}
class Derived : Base
{
  public override void Method(params int[] numbers) // Noncompliant, method can't be called with params syntax.
  {
    ...
  }
}
</pre>

## Compliant Solution

<pre>
class Base
{
  public virtual void Method(int[] numbers)
  {
    ...
  }
}
class Derived : Base
{
  public override void Method(int[] numbers)
  {
    ...
  }
}
</pre>