Jump statements, such as `return`, `yield break`, `goto`, and `continue` let you change the default
flow of program execution, but jump statements that direct the control flow to the original direction are just a waste of keystrokes.

## Noncompliant Code Example

<pre>
void Foo()
{
  goto A; // Noncompliant
  A:
  while (condition1)
  {
    if (condition2)
    {
      continue; // Noncompliant
    }
    else
    {
      DoTheThing();
    }
  }
  return; // Noncompliant; this is a void method
}
</pre>

## Compliant Solution

<pre>
void Foo()
{
  while (condition1)
  {
    if (!condition2)
    {
      DoTheThing();
    }
  }
}
</pre>