Nullable value types can hold either a value or `null`. The value held in the nullable type can be accessed with the `Value`
property, but `.Value` throws an `InvalidOperationException` when the value is `null`. To avoid the exception, a
nullable type should always be tested before `.Value` is accessed.

## Noncompliant Code Example

<pre>
int? nullable = null;
...
UseValue(nullable.Value); // Noncompliant
</pre>

## Compliant Solution

<pre>
int? nullable = null;
...
if (nullable.HasValue)
{
  UseValue(nullable.Value);
}
</pre>

or

<pre>
int? nullable = null;
...
if (nullable != null)
{
  UseValue(nullable.Value);
}
</pre>

## See

*   [MITRE, CWE-476](https://cwe.mitre.org/data/definitions/476.html) - NULL Pointer Dereference