The use of `==` to compare to objects is expected to do a reference comparison. That is, it is expected to return `true` if
and only if they are the same object instance. Overloading the operator to do anything else will inevitably lead to the introduction of bugs by
callers. On the other hand, overloading it to do exactly that is pointless; that's what `==` does by default.

## Noncompliant Code Example

<pre>
public static bool operator== (MyType x, MyType y) // Noncompliant
{
</pre>

## Exceptions

*   Classes with overloaded `operator +` or `operator -` methods are ignored.
*   Classes that implement `IComparable<T>` or `IEquatable<T>` most probably behave as a value-type objects and
      so are ignored.