The parameter to `Assembly.Load` includes the full specification of the dll to be loaded. Use another method, and you might end up with
a dll other than the one you expected. 

This rule raises an issue when `Assembly.LoadFrom`, `Assembly.LoadFile`, or `Assembly.LoadWithPartialName` is
called.

## Noncompliant Code Example

<pre>
static void Main(string[] args)
{
    Assembly.LoadFrom(...); // Noncompliant
    Assembly.LoadFile(...); // Noncompliant
    Assembly.LoadWithPartialName(...); // Noncompliant + deprecated
}
</pre>