Using the `readonly` keyword on a field means that it can't be changed after initialization. However, when applied to collections or
arrays, that's only partly true. `readonly` enforces that another instance can't be assigned to the field, but it cannot keep the contents
from being updated. That means that in practice, the field value really can be changed, and the use of `readonly` on such a field is
misleading, and you're likely to not be getting the behavior you expect.

This rule raises an issue when a non-private, `readonly` field is an array or collection.

## Noncompliant Code Example

<pre>
public class MyClass
{
  public readonly string[] strings;  // Noncompliant

  // ...
</pre>

## Compliant Solution

<pre>
public class MyClass
{
  public string[] strings;

  // ...
</pre>

or

<pre>
public class MyClass
{
  private readonly string[] strings;

  // ...
</pre>