The `IEquatable<T>` interface has only one method in it: `Equals(<T>)`. If you've already written
`Equals(T)`, there's no reason not to explicitly implement `IEquatable<T>`. Doing so expands the utility of your class by
allowing it to be used where an `IEquatable` is called for.

Similarly, having written `Equals(<T>)`, it's not that much further to go to write `Equals(Object)` and vice versa;
just a couple more lines brings a large dividend of functionality. So this rule raises an issue when `Equals(<T>)` is not accompanied
by `IEquatable` and `Equals(Object)`, and vice versa.

## Noncompliant Code Example

<pre>
class MyClass  // Noncompliant
{
  public override bool Equals(object other)
  {
    //...
  }
}
</pre>

<pre>
class MyClass  // Noncompliant
{
  public bool Equals(MyClass other)
  {
    //...
  }
}
</pre>

<pre>
class MyClass : IEquatable
 <t>
    // Noncompliant
{
}

 </t></pre>

## Compliant Solution

<pre>
class MyClass : IEquatable
 <myclass>

{
  public override bool Equals(object other)
  {
    return Equals(other as MyClass);
  }

  public bool Equals(MyClass other)
  {
    //...
  }
}

 </myclass></pre>