The value of a `static readonly` field is computed at runtime while the value of a `const` field is calculated at compile
time, which improves performance.

This rule raises an issue when a `static readonly` field is initialiazed with a value that is computable at compile time.

As specified by Microsoft, the list of types that can have a constant value are:

<table> 
 <tbody> 
  <tr> 
   <th>C# type</th> 
   <th>.Net Fwk type</th> 
  </tr> 
  <tr> 
   <td>bool</td> 
   <td>System.Boolean</td> 
  </tr> 
  <tr> 
   <td>byte</td> 
   <td>System.Byte</td> 
  </tr> 
  <tr> 
   <td>sbyte</td> 
   <td>System.SByte</td> 
  </tr> 
  <tr> 
   <td>char</td> 
   <td>System.Char</td> 
  </tr> 
  <tr> 
   <td>decimal</td> 
   <td>System.Decimal</td> 
  </tr> 
  <tr> 
   <td>double</td> 
   <td>System.Double</td> 
  </tr> 
  <tr> 
   <td>float</td> 
   <td>System.Single</td> 
  </tr> 
  <tr> 
   <td>int</td> 
   <td>System.Int32</td> 
  </tr> 
  <tr> 
   <td>uint</td> 
   <td>System.UInt32</td> 
  </tr> 
  <tr> 
   <td>long</td> 
   <td>System.Int64</td> 
  </tr> 
  <tr> 
   <td>ulong</td> 
   <td>System.UInt64</td> 
  </tr> 
  <tr> 
   <td>short</td> 
   <td>System.Int16</td> 
  </tr> 
  <tr> 
   <td>ushort</td> 
   <td>System.UInt16</td> 
  </tr> 
  <tr> 
   <td>string</td> 
   <td>System.String</td> 
  </tr> 
 </tbody> 
</table>

## Noncompliant Code Example

<pre>
namespace myLib
{
  public class Foo
  {
    static readonly int x = 1;  // Noncompliant
    static readonly int y = x + 4; // Noncompliant
    static readonly string s = "Bar";  // Noncompliant
  }
}
</pre>

## Compliant Solution

<pre>
namespace myLib
{
  public class Foo
  {
    const int x = 1;
    const int y = x + 4;
    const string s = "Bar";
  }
}
</pre>