When the parameters to the implementation of a `partial` method don't match those in the signature declaration, then confusion is almost
guaranteed. Either the implementer was confused when he renamed, swapped or mangled the parameter names in the implementation, or callers will be
confused.

## Noncompliant Code Example

<pre>
partial class Point
{
  partial void MoveVertically(int z);
}

partial class Point
{
  int x = 0;
  int y = 0;
  int z = 0;

  partial void MoveVertically(int y)  // Noncompliant
  {
    this.y = y;
  }
}
</pre>

## Compliant Solution

<pre>
partial class Point
{
  partial void MoveVertically(int z);
}

partial class Point
{
  int x = 0;
  int y = 0;
  int z = 0;

  partial void MoveVertically(int z)
  {
    this.z = z;
  }
}
</pre>

## See

*   MISRA C:2004, 8.3 - For each function parameter the type given in the declaration and definition shall be identical, and the return types shall
      also be identical
*   MISRA C:2004, 16.4 - The identifiers used in the declaration and definition of a function shall be identical.
*   MISRA C++:2008, 8-4-2 - The identifiers used for the parameters in a re-declaration of a function shall be identical to those in the
      declaration.
*   MISRA C:2012, 8.3 - All declarations of an object or function shall use the same names and type qualifiers.
*   [CERT, DCL40-C.](https://www.securecoding.cert.org/confluence/x/cwGTAw) - Do not create incompatible declarations of the same
      function or object