### AvoidArgumentExceptionDefaultConstructorRule
This rule checks that every **System.ArgumentException**, **System.ArgumentNullException**, **System.ArgumentOutOfRangeException**, or **System.DuplicateWaitObjectException** exception created is provided with some useful information about the exception being thrown, minimally the parameter name.

**Bad** example:

``` csharp
public void Add (object key, object value)
{
    if ((obj == null) || (key == null)) {
        throw new ArgumentNullException ();
    }
    Inner.Add (key, value);
}
```
**Good** example:

``` csharp
public void Add (object key, object value)
{
    if (key == null) {
        throw new ArgumentNullException ("key");
    }
    if (obj == value) {
        throw new ArgumentNullException ("value");
    }
    Inner.Add (key, value);
}
```
**Notes**

-   This rule is available since Gendarme 2.0
