### AvoidCodeDuplicatedInSiblingClassesRule
This rule looks for code duplicated in sibling subclasses.

**Bad** example:

``` csharp
public class BaseClassWithCodeDuplicated {
    protected IList list;
}
 
public class OverriderClassWithCodeDuplicated : BaseClassWithCodeDuplicated {
    public void CodeDuplicated ()
    {
        foreach (int i in list) {
            Console.WriteLine (i);
        }
        list.Add (1);
    }
}
 
public class OtherOverriderWithCodeDuplicated : BaseClassWithCodeDuplicated {
    public void OtherMethod ()
    {
        foreach (int i in list) {
            Console.WriteLine (i);
        }
        list.Remove (1);
    }
}
```
**Good** example:

``` csharp
public class BaseClassWithoutCodeDuplicated {
    protected IList list;
 
    protected void PrintValuesInList ()
    {
        foreach (int i in list) {
            Console.WriteLine (i);
        }
    }
}
 
public class OverriderClassWithoutCodeDuplicated : BaseClassWithoutCodeDuplicated {
    public void SomeCode ()
    {
        PrintValuesInList ();
        list.Add (1);
    }
}
 
public class OtherOverriderWithoutCodeDuplicated : BaseClassWithoutCodeDuplicated {
    public void MoreCode ()
    {
        PrintValuesInList ();
        list.Remove (1);
    }
}
```