### AvoidLongParameterListsRule
This rule allows developers to measure the parameter list size in a method. If you have methods with a lot of parameters, perhaps you have a Long Parameter List smell. This rule counts the method's parameters, and compares it against a maximum value. If you have an overloaded method, then the rule will get the shortest overload and compare the shortest overload against the maximum value. Other time, it's quite hard determine a long parameter list. By default, a method with 6 or more arguments will be flagged as a defect.

**Bad** example:

``` csharp
public void MethodWithLongParameterList (int x, char c, object obj, bool j, string f,
float z, double u, short s, int v, string[] array)
{
    // Method body ...
}
```
**Good** example:

``` csharp
public void MethodWithoutLongParameterList (int x, object obj)
{
    // Method body....
}
```