### AvoidSpeculativeGeneralityRule
This rule allows developers to avoid the Speculative Generality smell. Be careful if you are developing a new framework or a new library, because this rule only inspects the assembly, then if you provide an abstract base class for extend by third party people, then the rule can warn you. You can ignore the message in this special case. We detect this smell by looking for:

-   Abstract classes without responsibility
-   Unnecessary delegation.
-   Unused parameters.

**Bad** example:

``` csharp
// An abstract class with only one subclass.
public abstract class AbstractClass {
    public abstract void MakeStuff ();
}
 
public class OverriderClass : AbstractClass {
    public override void MakeStuff ()
    {
    }
}
```
If you use Telephone class only in one client, perhaps you don't need this kind of delegation.

``` csharp
public class Person {
    int age;
    string name;
    Telephone phone;
}
 
public class Telephone {
    int areaCode;
    int phone;
}
```
**Good** example:

``` csharp
public abstract class OtherAbstractClass{
    public abstract void MakeStuff ();
}
 
public class OtherOverriderClass : OtherAbstractClass {
    public override void MakeStuff ()
    {
    }
}
 
public class YetAnotherOverriderClass : OtherAbstractClass {
    public override void MakeStuff ()
    {
    }
}
```