### CallBaseMethodsOnISerializableTypesRule
This rule checks types that implement the **System.ISerializable** interface and fires if either the serialization constructor or the **GetObjectData**method does not call it's **base** type, potentially breaking the serialization process.

**Bad** example:

``` csharp
[Serializable]
public class Base : ISerializable {
    // ...
}
 
[Serializable]
public class Bad : Base {
    int value;
 
    protected BadDerived (SerializationInfo info, StreamingContext context)
    {
        value = info.GetInt32 ("value");
    }
 
    public override void GetObjectData (SerializationInfo info, StreamingContext context)
    {
        info.AddValue ("value", value);
    }
}
```
**Good** example:

``` csharp
[Serializable]
public class Base : ISerializable {
    // ...
}
 
[Serializable]
public class Good : Base {
    int value;
 
    protected BadDerived (SerializationInfo info, StreamingContext context) : base (info, context)
    {
        value = info.GetInt32 ("value");
    }
 
    public override void GetObjectData (SerializationInfo info, StreamingContext context)
    {
        info.AddValue ("value", value);
        base.GetObjectData (info, context);
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.2
